using UnityEngine;

public class Mover : MonoBehaviour
{
    [SerializeField] private float speed = 5f;   // Movement speed, adjustable in Inspector
    [SerializeField] private float range = 3f;   // How far left/right it moves

    private Vector3 startPos;
    private int direction = 1;

    void Start()
    {
        // Save the starting position
        startPos = transform.position;
    }

    void Update()
    {
        // Move left and right
        transform.Translate(Vector3.right * direction * speed * Time.deltaTime);

        // If we've gone too far, flip direction
        if (Mathf.Abs(transform.position.x - startPos.x) > range)
        {
            direction *= -1;
        }
    }

    // Just to show another MonoBehaviour method
    private void OnDrawGizmosSelected()
    {
        // Draw a gizmo to visualize the movement range in the editor
        Gizmos.color = Color.yellow;
        Gizmos.DrawLine(transform.position + Vector3.left * range, transform.position + Vector3.right * range);
    }
}